\def\fileversion{1.000}
\def\filedate{2020/04/30}

\NeedsTeXFormat{LaTeX2e}

\ProvidesClass{DLRK_v1.0}[\filedate\space Version \fileversion\space by Nicolas Fezans]

\newif\if@final
\newif\if@draft
\DeclareOption{final}{\@finaltrue}
\DeclareOption{draft}{\@drafttrue}



\DeclareOption{german}{
  \newcommand{\LoadCsquotes}{\RequirePackage[german=quotes]{csquotes}}
  \newcommand{\AbstractSectionName}{Zusammenfassung}
  \newcommand{\NomenclatureSectionName}{\texorpdfstring{\uppercase{Nomenklatur}}{Nomenklatur}}
  \newcommand{\figref}[1]{Bild~\ref{#1}}
  \newcommand{\tabref}[1]{Tab.~\ref{#1}}
  \newcommand{\ContactSection}{Kontaktadresse:}
}
\DeclareOption{ngerman}{
  \newcommand{\LoadCsquotes}{\RequirePackage[german=quotes]{csquotes}}
  \newcommand{\AbstractSectionName}{Zusammenfassung}
  \newcommand{\NomenclatureSectionName}{\texorpdfstring{\uppercase{Nomenklatur}}{Nomenklatur}}
  \newcommand{\figref}[1]{Bild~\ref{#1}}
  \newcommand{\tabref}[1]{Tab.~\ref{#1}}
  \newcommand{\ContactSection}{Kontaktadresse:}
}
\DeclareOption{english}{
  \newcommand{\LoadCsquotes}{\RequirePackage{csquotes}}
  \newcommand{\AbstractSectionName}{Abstract}
  \newcommand{\NomenclatureSectionName}{\texorpdfstring{\uppercase{Nomenclature}}{Nomenclature}}
  \newcommand{\figref}[1]{Fig~\ref{#1}}
  \newcommand{\tabref}[1]{Tab.~\ref{#1}}
  \newcommand{\ContactSection}{Contact address:}
}

\DeclareOption*{\PassOptionsToClass{\CurrentOption}{extarticle}}%




\if@final
\fi
\if@draft
  \doublespacing
\fi


\ProcessOptions\relax



\LoadClass{extarticle}

\RequirePackage{uarial}
\renewcommand{\familydefault}{\sfdefault}

\RequirePackage[T1]{fontenc}
\RequirePackage[utf8]{inputenc}

\LoadCsquotes

\RequirePackage[a4paper,twocolumn,margin=2.0cm,left=2.0cm,right=2.0cm]{geometry}
\setlength{\columnsep}{5mm}
\RequirePackage{setspace}
\singlespacing

\setlength{\parskip}{0pt}
\setlength{\parindent}{0.0cm}



\RequirePackage{bm}


\RequirePackage{enumitem}
\setlist{labelindent=\parindent,leftmargin=*,nosep}
\setlist[enumerate]{label={\arabic*)}}



\RequirePackage[style]{abstract}
\renewcommand{\abstitlestyle}[1]{\noindent\bfseries\normalsize\center{\AbstractSectionName}}
\renewcommand{\abstracttextfont}{\noindent\normalsize}
\setlength{\absleftindent}{0.0cm}
\setlength{\absrightindent}{0.0cm}

\renewcommand{\abstracttextfont}{\normalfont}
\renewcommand{\abstractnamefont}{\normalfont\bfseries}



\renewcommand{\maketitle}{%
  \vspace*{-\topskip}      % remove the initial space
  \begingroup
  \centering
  \hrule height \z@        % to avoid the insertion of lineskip glue
  {\vspace*{2cm}\Large\MakeUppercase{\@title}\par}
  \vskip\baselineskip
	\@author
  \endgroup
  \if@draft
    \thispagestyle{empty}
  \fi
  \setcounter{footnote}{0}
}

\newcommand{\makepaperkeywords}{
\begin{center}
\textbf{Keywords}\\ \paperkeywords
\end{center}
}

\setlength{\emergencystretch}{2.5em}


\RequirePackage[largestsep]{titlesec}
\renewcommand{\thesection}{\arabic{section}}
\renewcommand{\thesubsection}{\thesection.\arabic{subsection}}
\renewcommand{\thesubsubsection}{\thesubsection.\arabic{subsubsection}}

\titleformat{\section}{\normalsize\bfseries\singlespacing\uppercase}{\thesection.\space\space}{0pt}{}[]
\titlespacing{\section}{0pt}{6pt}{6pt}


\titleformat{\subsection}{\normalsize\bfseries\singlespacing}{\thesubsection.\space\space}{0pt}{}[]
\titlespacing{\subsection}{0pt}{0pt}{6pt}

\titleformat{\subsubsection}{\normalsize\bfseries\singlespacing}{\thesubsubsection.\space\space}{0pt}{}[]
\titlespacing{\subsubsection}{0pt}{0pt}{6pt}

\titleformat{\paragraph}{\normalsize\singlespacing}{\theparagraph\space\space}{0pt}{}[]
%\titlespacing{\paragraph}{0pt}{-4.0ex+9pt}{0pt}


\RequirePackage{xcolor}
\definecolor{icecyan}{rgb}{0,0.6250,0.8867}
\definecolor{darkblue}{rgb}{0,0,.5}
\definecolor{darkblue2}{rgb}{0,0,.2}
\definecolor{navy}{rgb}{0,0,0.5020}
\definecolor{steelblue}{rgb}{0.3431,0.6373,0.8824}%{0.2745,0.5098,0.7059}
\definecolor{darkgray}{gray}{0.4}
\definecolor{gray1}{rgb}{0.3725,0.3725,0.3725}
\definecolor{graylight}{rgb}{0.9529,0.9529,0.9529}
\definecolor{darkgreen}{rgb}{0.0,0.7,0.3}
\definecolor{darkcyan}{rgb}{0.0,0.3137,0.3137}
\definecolor{middlecyan}{rgb}{0.0,0.5373,0.5373}
\definecolor{lightcyan}{rgb}{0.0,0.8118,0.8118}
\definecolor{lightercyan}{rgb}{0.0,1.0,1.0}
\definecolor{darkorchid4}{rgb}{0.4078,0.1333,0.5451}
\definecolor{palegreen2}{rgb}{0.5647,0.9333,0.5647}

\RequirePackage[
pdfborder={0 0 0},
pdfstartview={Fit},
colorlinks=true,
citecolor={black},
linkcolor={black},
urlcolor={darkblue},
bookmarksopen=false,
pdfdisplaydoctitle=true,
pdfpagelayout=TwoColumnRight
]{hyperref}


\RequirePackage[all]{nowidow}
\RequirePackage{soul}


\RequirePackage[tableposition=top]{caption}
\renewcommand{\figurename}{Fig.}
\captionsetup*{font=small,labelfont=bf,textfont=bf,labelsep=quad}
\renewcommand{\arraystretch}{1.2}

\newcommand{\keywords}[1]{\noindent\begin{small}{\textbf{Keywords:}~#1}\end{small}}

\RequirePackage[indentfirst=false,font+=small,leftmargin=1.0cm,rightmargin=1.0cm,vskip=4pt]
{quoting}

\setlength{\abovedisplayskip}{\baselineskip}
\setlength{\belowdisplayskip}{\baselineskip}
\setlength{\abovedisplayshortskip}{\baselineskip}
\setlength{\belowdisplayshortskip}{\baselineskip}



\setlength\parindent{0cm}


\RequirePackage{babel}
\addto\captionsngerman{
  \renewcommand{\figurename}{BILD}
  \renewcommand{\tablename}{TAB}
}
\addto\captionsgerman{
  \renewcommand{\figurename}{BILD}
  \renewcommand{\tablename}{TAB}
}
\addto\captionsenglish{
  \renewcommand{\figurename}{FIG}
  \renewcommand{\tablename}{TAB}
}


\RequirePackage{graphicx,dblfloatfix}
\RequirePackage[format=hang,labelsep=period]{caption}
\RequirePackage{subcaption}
\RequirePackage{fancybox,framed}



\RequirePackage[leqno]{amsmath}
\RequirePackage{amssymb,amsthm}
\RequirePackage{gensymb}


\setlength{\abovecaptionskip}{5pt plus 0pt minus 2pt}
\setlength{\belowcaptionskip}{3pt}



\def\labelitemi{$\vcenter{\hbox{\tiny$\bullet$}}$}





\bibliographystyle{DLRK_v1.0}

\RequirePackage{cite}

\def\@fnsymbol#1{\ensuremath{\ifcase#1\or *\or \dagger\or \ddagger\or
   \mathsection\or \mathparagraph\or \|\or **\or \dagger\dagger
   \or \ddagger\ddagger \else\@ctrerr\fi}}
\newcommand{\ssymbol}[1]{\ensuremath{^{\@fnsymbol{#1}}}}



\RequirePackage[intoc]{nomencl}
\newcommand{\nomunit}[1]{\renewcommand{\nomentryend}{\hspace*{\fill}#1}}

\renewcommand{\nomname}{\NomenclatureSectionName}
\RequirePackage{ifthen} % Group Symbols
